// XISLIfChildTag.cpp: CXISLIfChildTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLIfChildTag.h"
#include "XISLExitTag.h"
#include "XISLSwitchTag.h"
#include "XISLIfTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLIfChildTag::CXISLIfChildTag(int nType,CXISLTag *pParentTag)
{
	m_pParentTag = pParentTag;
	if(nType == ID_TAG_THEN)
		m_nBmpID = IDB_CASE;
	else if(nType == ID_TAG_ELSE)
		m_nBmpID = IDB_CASE;

	m_nTagType = nType;
	m_rectNextBMP = CRect(0,0,0,0);
	m_bExcAct = TRUE;
	m_pExitTag = NULL;
}

CXISLIfChildTag::~CXISLIfChildTag()
{

}

CXISLIfChildTag::CXISLIfChildTag(const CXISLIfChildTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	for(int i=0; i<cpXISL.m_ActionList.GetCount(); i++)
	{
		POSITION pos = cpXISL.m_ActionList.FindIndex(i);
		m_ActionList.AddTail(cpXISL.m_ActionList.GetAt(pos));
	}
	m_bExcAct = cpXISL.m_bExcAct;
	m_pExitTag = cpXISL.m_pExitTag;
	m_rectNextBMP = cpXISL.m_rectNextBMP;
}

CXISLIfChildTag& CXISLIfChildTag::operator=(const CXISLIfChildTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		for(int i=0;i<m_ActionList.GetCount();i++)
		{
			POSITION pos = m_ActionList.FindIndex(i);
			CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
			delete pActItem;
		}
		m_ActionList.RemoveAll();
		for(i=0; i<cpXISL.m_ActionList.GetCount(); i++)
		{
			POSITION pos = cpXISL.m_ActionList.FindIndex(i);
			m_ActionList.AddTail(cpXISL.m_ActionList.GetAt(pos));
		}
		m_bExcAct = cpXISL.m_bExcAct;
		m_pExitTag = cpXISL.m_pExitTag;
		m_rectNextBMP = cpXISL.m_rectNextBMP;
	}
	return *this;
}

//CSize CXISLActTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Faction̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLIfChildTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);

	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	CFont *pOldFont;
	CFont font;
	font.CreateFont(12,0,0,0,FW_BOLD,TRUE,FALSE,FALSE,
		SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
		DRAFT_QUALITY,DEFAULT_PITCH,_T("lr oSVbN"));
	pOldFont = pDC->SelectObject(&font);
	pDC->SetTextColor(RGB(80,80,80));
	pDC->SetBkMode(TRANSPARENT);
	if(m_nTagType==ID_TAG_ELSE)
		pDC->DrawText("ELSE",m_rectBMP,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
	else if(m_nTagType==ID_TAG_THEN)
		pDC->DrawText("THEN",m_rectBMP,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
	pDC->SelectObject(pOldFont);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;

	pDC->MoveTo(nX,nY);
	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	int nBX = nX;
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);

	return CXISLActTag::DrawXISLFlow(pDC,nX,nY);
}

//CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLIfChildTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
		return CXISLActTag::FindTag(point,bOnly);
	return NULL;
}

LPCTSTR CXISLIfChildTag::GetXISLString()
{
	m_strXISL.Empty();
	m_strXISL = "<";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	if(m_ActionList.IsEmpty())
	{
		m_strXISL += "</";
		m_strXISL += XISL_TAG_NAME[m_nTagType];
		m_strXISL += ">\r\n";
		return m_strXISL;
	}

	for(int i=0;i<m_ActionList.GetCount();i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
		m_strXISL += pActItem->GetXISLString();
	}

	if(m_pExitTag)
		m_strXISL += m_pExitTag->GetXISLString();

	m_strXISL += "</";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";
	return m_strXISL;
}

void CXISLIfChildTag::DeleteItem()
{
	CXISLActTag *pActTag;
	while(m_ActionList.IsEmpty()==0){
		pActTag=(CXISLActTag *)m_ActionList.GetHead();
		if(pActTag->m_nTagType==ID_TAG_SWITCH){
			((CXISLSwitchTag *)pActTag)->DeleteItemIntoCase();
		}
		else if(pActTag->m_nTagType == ID_TAG_IF || pActTag->m_nTagType == ID_TAG_ELSEIF){
			((CXISLIfTag *)pActTag)->DeleteALL();
		}
		delete pActTag;
		pActTag=NULL;
		m_ActionList.RemoveHead();
	}
}